//=============================================================================
// MarkusPlayer.
//
// Custom player class for the markistan mod.
//=============================================================================
class MarkistanPlayer extends MarkistanTroopMale; 

exec function CleanUp()
{
 local DeusExPlayer P;
 
 forEach AllActors(class'DeusExPlayer', P)
 {
  if (P != None && P != Self)
  {
   P.Destroy();
  }
 }
}

exec function AugAdd(class<Augmentation> aWantedAug)
{
 Super(DeusExPlayer).AugAdd(aWantedAug);
}

exec function Tantalus()
{
 Super(DeusExPlayer).Tantalus();
}

exec function OpenSesame()
{
 Super(DeusExPlayer).OpenSesame();
}

exec function AllAugs()
{
 Super(DeusExPlayer).AllAugs();
}

exec function Invisible(bool B)
{
 Super(DeusExPlayer).Invisible(B);
}

exec function AllSkills()
{
 Super(DeusExPlayer).AllSkills();
}

exec function AllHealth()
{
 Super(DeusExPlayer).AllHealth();
}

exec function AllEnergy()
{
 SugarRush();
}

exec function AllWeapons()
{
 Super(DeusExPlayer).AllWeapons();
}

exec function SloMo( float T )
{
 Super(DeusExPlayer).SloMo(T);
}

exec function AllAmmo()
{
 Super(DeusExPlayer).AllAmmo();
}	

exec function SpawnMass(Name ClassName, optional int TotalCount)
{
	local actor        spawnee;
	local vector       spawnPos;
	local vector       center;
	local rotator      direction;
	local int          maxTries;
	local int          count;
	local int          numTries;
	local float        maxRange;
	local float        range;
	local float        angle;
	local class<Actor> spawnClass;
	local string		holdName;
	local Vector Pos;

	 Pos = Location;
	 Pos.Z += BaseEyeHeight;

	if (!bCheatsEnabled)
		return;

	if (!bAdmin && (Level.Netmode != NM_Standalone))
		return;

	if (instr(ClassName, ".") == -1)
		holdName = "Markistan." $ ClassName;
	else
		holdName = "" $ ClassName;  // barf

	spawnClass = class<actor>(DynamicLoadObject(holdName, class'Class'));

	if (spawnClass == None)
	{
	 holdName = "DeusEx." $ ClassName;

	 spawnClass = class<actor>(DynamicLoadObject(holdName, class'Class'));

	 if (spawnClass == None)
	 {
		ClientMessage("Illegal actor name "$GetItemName(String(ClassName)));
		return;
         }
	}

	if (totalCount <= 0)
		totalCount = 10;
	if (totalCount > 250)
		totalCount = 250;
	maxTries = totalCount*2;
	count = 0;
	numTries = 0;
	maxRange = sqrt(totalCount/3.1416)*4*SpawnClass.Default.CollisionRadius;

	direction = ViewRotation;
	direction.pitch = 0;
	direction.roll  = 0;
	center = Location + Vector(direction)*(maxRange+SpawnClass.Default.CollisionRadius+CollisionRadius+20);
	while ((count < totalCount) && (numTries < maxTries))
	{
		angle = FRand()*3.14159265359*2;
		range = sqrt(FRand())*maxRange;
		spawnPos.X = sin(angle)*range;
		spawnPos.Y = cos(angle)*range;
		spawnPos.Z = 0;
		spawnee = spawn(SpawnClass,,,center+spawnPos, ViewRotation);
		if (spawnee != None)
			count++;
		numTries++;
	}

	ClientMessage(count$" actor(s) spawned");

}


exec function Summon(string ClassName)
{
	local String ClassNameFin;
	local class<actor> NewClass;
	local Vector Pos;

	 Pos = Location;
	 Pos.Z += BaseEyeHeight;

	if (!bCheatsEnabled)
		return;

	if(!bAdmin && (Level.Netmode != NM_Standalone))
		return;
	if(instr(ClassName, ".") == -1)
		ClassNameFin = "Markistan." $ ClassName;
	else
		ClassNameFin = ClassName;

	//Spawn( NewClass,,,Location + (CollisionRadius+NewClass.Default.CollisionRadius+30) * Vector(Rotation) + vect(0,0,1) * 15, Rotation );

		log( "Fabricate " $ ClassNameFin );
	NewClass = class<actor>( DynamicLoadObject( ClassNameFin, class'Class' ) );
	if( NewClass!=None )
		// DEUS_EX STM
		//Spawn( NewClass,,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );

		Spawn( NewClass,,,Location + (CollisionRadius+NewClass.Default.CollisionRadius+30) * Vector(Rotation) + vect(0,0,1) * 15, ViewRotation );

	if (NewClass == None)
	{

	if(instr(ClassName, ".") == -1)
		ClassNameFin = "DeusEx." $ ClassName;

	log( "Fabricate " $ ClassNameFin );
	NewClass = class<actor>( DynamicLoadObject( ClassNameFin, class'Class' ) );
	if( NewClass!=None )
		// DEUS_EX STM
		//Spawn( NewClass,,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
		Spawn( NewClass,,,Location + (CollisionRadius+NewClass.Default.CollisionRadius+30) * Vector(Rotation) + vect(0,0,1) * 15, ViewRotation );
	}
}

exec function God()
{
 Super(DeusExPlayer).God();
}

exec function Ghost()
{
 Super(DeusExPlayer).Ghost();
}

exec function Fly()
{
 Super(DeusExPlayer).Fly();
}

exec function AllCredits()
{
 Super(DeusExPlayer).AllCredits();
}

exec function ShowMainMenu()
{
 Super(DeusExPlayer).ShowMainMenu();
}

defaultproperties
{
     TruePlayerName="Epic Karkian"
     SkillPointsTotal=5000
     SkillPointsAvail=5000
     Credits=500
     strStartMap="01_NYC_UnatcoIsland"
     CarcassType=Class'Markistan.MarkistanTroopCarcass'
     FamiliarName="JC Denton"
     UnfamiliarName="JC Denton"
     bCheatsEnabled=True
}
